/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.StringListImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import java.util.ArrayList;
import java.util.List;

public class StringListSerialization
extends PropertySerialization {
    public static final StringListSerialization INSTANCE = new StringListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        List list;
        PropertySerializerCall call = this.enter("ListOfString", object, context);
        Object value = call.property.getObjectValue();
        List list2 = list = value instanceof List ? (List)value : null;
        if (list != null && list.size() > 0) {
            Util.checkListForNulls(list, call.property.getPropertyName());
            String[] values = list.toArray(new String[list.size()]);
            if (context.isWritingXML() && !XMLHelper.isValidText(values)) {
                XMLHelper.encodeText(values);
                if (context.isClientProcessing() || context.getVersion() > 350) {
                    context.writeAttribute("encoding", "H9");
                }
            }
            context.writeElementArray("Value", context.getOptionalXsdType("string"), values);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        String encoding = context.getAttribute("encoding");
        PropertyDeserializerCall call = this.enter(object, context);
        List values = context.readElementList("Value");
        if (encoding != null && encoding.equals("H9")) {
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                values.set(i, XMLHelper.decodeText((String)values.get(i)));
            }
        }
        PropertyStringListImpl property = new PropertyStringListImpl(call.propertyId, new StringListImpl(values), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<String> values = new ArrayList<String>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(jsonVals.getString(i));
            }
        }
        PropertyStringListImpl property = new PropertyStringListImpl(call.propertyId, new StringListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }
}

