/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.reference;

import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.ObjectByPath;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.wsi.serialization.Context;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ReferenceValues;

public class DependentIdentitySerialization
extends ObjectReferenceSerialization {
    public static final DependentIdentitySerialization INSTANCE = new DependentIdentitySerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        DependentIdentity reference = (DependentIdentity)object;
        ReferenceValues values = this.getValues(reference, context);
        context.writeSchemaType(this.getTypeName(reference, context));
        context.writeAttribute("classId", values.classId);
        context.writeAttribute("objectId", values.objectId);
        context.writeAttribute("objectStore", values.objectStore);
        context.writeAttribute("path", values.path);
        context.writeAttribute("propertyId", values.propertyId);
        context.writeAttribute("itemIndex", Util.toIntString(values.itemIndex));
        context.leaveElement();
    }

    @Override
    public String getTypeName(ObjectReferenceBase reference, Context context) {
        return "ObjectSpecification";
    }

    @Override
    public String getObjectId(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        if (parent == null || parent instanceof ObjectByPath) {
            return null;
        }
        return parent.getObjectIdentity();
    }

    @Override
    public String getPath(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        return parent instanceof ObjectByPath ? parent.getObjectIdentity() : null;
    }

    @Override
    public String getPropertyId(ObjectReferenceBase reference, Context context) {
        return ((DependentIdentity)reference).getPropertyName();
    }

    @Override
    public Integer getItemIndex(ObjectReferenceBase reference, Context context) {
        return ((DependentIdentity)reference).getIndex();
    }

    @Override
    public ReferenceValues getValues(ObjectReferenceBase reference, Context context) {
        DependentIdentity identity = (DependentIdentity)reference;
        ObjectReferenceBase parent = (ObjectReferenceBase)identity.getParentReference();
        ReferenceValues values = new ReferenceValues();
        if (parent != null) {
            if (parent instanceof ObjectByPath) {
                values.path = parent.getObjectIdentity();
            } else {
                values.objectId = parent.getObjectIdentity();
            }
            values.classId = parent.getClassIdentity();
            values.objectStore = parent.getObjectStoreIdentity();
        }
        values.propertyId = identity.getPropertyName();
        values.itemIndex = identity.getIndex();
        return values;
    }

    @Override
    public ObjectReferenceBase getParent(ObjectReferenceBase reference) {
        return (ObjectReferenceBase)((DependentIdentity)reference).getParentReference();
    }
}

