#!/bin/bash

echo "Creating Harbor image pull secret..."
oc create secret docker-registry harbor-pull-secret \
  --docker-server=harbor-kfc.ilionx-ocp.com \
  --docker-username=${HARBOR_USERNAME} \
  --docker-password=${HARBOR_PASSWORD} \
  --docker-email=${HARBOR_EMAIL} \
  -n tonic-textual --dry-run=client -o yaml | oc apply -f -

echo "Deploying Tonic Textual to OpenShift..."

echo "1. Creating namespace and service account..."
oc apply -f 01-namespace.yaml
oc apply -f 02-configmap.yaml
oc apply -f 03-secret.yaml
oc apply -f 04-service-account.yaml

echo "2. Creating persistent volumes..."
oc apply -f 05-pvcs.yaml

echo "3. Waiting for PVCs to be bound..."
oc wait --for=condition=Bound pvc --all -n tonic-textual --timeout=300s

echo "4. Deploying database..."
oc apply -f 06-postgres-deployment.yaml
oc apply -f 07-postgres-service.yaml

echo "5. Waiting for database to be ready..."
oc wait --for=condition=available deployment/textual-db -n tonic-textual --timeout=300s

echo "6. Deploying application services..."
oc apply -f 08-textual-api-deployment.yaml
oc apply -f 09-textual-api-service.yaml
oc apply -f 10-textual-worker-deployment.yaml
oc apply -f 11-textual-ml-deployment.yaml
oc apply -f 12-textual-ml-service.yaml
oc apply -f 13-log-shipper-deployment.yaml

echo "7. Creating route for external access..."
oc apply -f 14-route.yaml

echo "8. Applying network policy (optional)..."
oc apply -f 15-networkpolicy.yaml

echo "Deployment completed successfully!"
echo "Getting application URL..."
oc get route textual-api-route -n tonic-textual -o jsonpath='{.spec.host}'
echo ""

echo "Monitoring deployment status..."
oc get pods -n tonic-textual -w
